class QaalApp {
    settings = null;
    get scrollTopButtonElement() {
        return $('#Qaal_ScrollToTopButton');
    }

    constructor() {
        let self = this;
        self.init();
    }

    async init() {
        let self = this;
        this.initButtons();
        this.initScollUpButton();
        await self.getSettings();
    }

    async getSettings() {
        let self = this;
        await fetch('app_config.json')
            .then((response) => response.json())
            .then((json) => { self.settings = json });
    }

    initButtons() {
        $('.fourover-qaal-button').on('click', function () {
            new StatusPopupMessage($(this)).show();
        });
    }

    initScollUpButton() {
        let self = this;
        var offset = 200;
        var duration = 100;
        $(window).scroll(function () {
            if ($(this).scrollTop() > offset) {
                self.scrollTopButtonElement.fadeIn(duration);
            } else {
                self.scrollTopButtonElement.fadeOut(duration);
            }
        });
        self.scrollTopButtonElement.click(function (event) {
            event.preventDefault();
            $('html, body').animate({ scrollTop: 0 }, duration);
            return false;
        })
    }

    showResult(title, link) {
        let imageUrl = $(link).attr('imageUrl');
        new ModalDialog(title, `<img src="${imageUrl}" style="width: 100%; height: 100%" />`).show();
    }
}