class Http {
    static async post(url, body) {
        var myHeaders = new Headers();
        myHeaders.append("Content-Type", "application/json");
        var requestOptions = {
            method: 'POST',
            headers: myHeaders,
            body: body,
            redirect: 'follow'
        };
        return await Http.makeFetch(url, requestOptions);
    }

    static async makeFetch(url, options) {
        var fetchResult = null;
        console.log('Calling ' + url, options)
        await fetch(url, options)
            .then(response => response.text())
            .then(result => {
                console.log('Done. Result: ' + result);
                fetchResult = result;
            })
            .catch(error => console.log('error', error));
        return fetchResult;
    }
}