class ModalDialog {
    _wrapper = null;
    _dialog = null;
    _content = null;
    _header = null;
    _title = null;
    _closeButton = null;
    _body = null;

    get dialogWrapper() {
        let self = this;
        if (self._wrapper == null) {
            self._wrapper = $('<div />', {
                'class': 'modal fade',
                tabindex: -1,
                role: 'dialog',
                'aria-hidden': true
            });
        }
        return self._wrapper;
    }

    get dialog() {
        let self = this;
        if (self._dialog == null) {
            self._dialog = $('<div />', {
                'class': 'modal-dialog modal-dialog-centered modal-lg',
                role: document
            });
        }
        return self._dialog;
    }

    get content() {
        let self = this;
        if (self._content == null) {
            self._content = $('<div />', {
                'class': 'modal-content'
            });
        }
        return self._content;
    }

    get header() {
        let self = this;
        if (self._header == null) {
            self._header = $('<div />', {
                'class': 'modal-header'
            });
        }
        return self._header;
    }

    get title() {
        let self = this;
        if (self._title == null) {
            self._title = $('<h5 />', {
                'class': 'modal-title'
            });
        }
        return self._title;
    }

    get closeButton() {
        let self = this;
        if (self._closeButton == null) {
            self._closeButton = $('<div />', {
                type: 'button',
                'class': 'close',
                'data-dismiss': 'modal',
                'area-label': 'close',
                'style': 'font-size: 1.5rem; font-weight: 700',
                'html': '<span aria-hidden="true">&times;</span>'
            });
        }
        return self._closeButton;
    }

    get body() {
        let self = this;
        if (self._body == null) {
            self._body = $('<div />', {
                'class': 'modal-body'
            });
        }
        return self._body;
    }

    constructor(titleText, bodyText) {
        let self = this;
        self.header.append(self.title).append(self.closeButton);
        self.content.append(self.header).append(self.body);
        self.dialog.append(self.content);
        self.dialogWrapper.append(self.dialog);
        $('body').append(self.dialogWrapper);
        self.closeButton.on('click', function () { self.dialogWrapper.modal('hide') });
        self.dialogWrapper.on('hidden.bs.modal', function () {
            self.dialogWrapper.modal('dispose');
            self.dialogWrapper.remove();
        });
        self.title.html(titleText);
        self.body.html(bodyText);
    }

    show() {
        let self = this;
        self.dialogWrapper.modal('show');
    }
}