class PopupMessage {
    _container = null;
    isAutohide = true;
    _popup = null;
    _header = null;
    _headerContent = null;
    _body = null;
    _closeButton = null;
    bodyText;

    get container() {
        if (this._container == null) {
            this._container = $('#MainToastContainer');
        }
        return this._container;
    }

    get popup() {
        let self = this;
        if (self._popup == null) {
            self._popup = $('<div>', {
                role: 'alert',
                'aria-live': 'assertive',
                'aria-atomic': 'true',
                class: 'toast mb-2',
                'data-bs-autohide': self.isAutohide
            });
        }
        return this._popup;
    }

    get header() {
        if (this._header == null) {
            this._header = $('<small>', {
                class: 'fourover-qaal-popup-header'
            });
        }
        return this._header;
    }

    get headerContent() {
        if (this._headerContent == null) {
            this._headerContent = $('<div>',
                {
                    class: 'd-flex position-relative',
                    html: '<small class="position-relative fourover-qaal-popup-header-text w-auto me-auto"></small>'
                });
        }
        return this._headerContent;
    }

    get body() {
        if (this._body == null) {
            this._body = $('<div>', {
                class: 'toast-body'
            });
        }
        return this._body;
    }

    get bodyContent() {
        if (this._headerContent == null) {
            this._headerContent = $('<div>',
                {
                    class: 'popup-body-content',
                    html: '<span class="position-relative popup-body-text w-auto me-auto"></span>'
                });
        }
        return this._headerContent;
    }

    get closeButton() {
        if (this._closeButton == null) {
            this._closeButton = $('<button>', {
                class: 'btn-close fourover-qaal-popup-close-button',
                'data-bs-dismiss': 'toast',
                'aria-label': 'Close'
            });
        }
        return this._closeButton;
    }

    constructor(headerText, bodyText, isAutohide = true, hideInMilliseconds = null, supressCreation = false) {
        if (supressCreation) return;
        let self = this;
        self.isAutohide = isAutohide;
        self.header.html(headerText);
        self.bodyContent.find('.popup-body-text').html(bodyText);
        self.body.html(self.bodyContent);
        self.popup
            .append(self.header)
            .append(self.body);
        self.closeButton.insertAfter(self.header);
        self.container.append(self.popup);
        self.popup.on('hidden.bs.toast', function () {
            self.destroy();
        });
        if (hideInMilliseconds != null) {
            setTimeout(function () {
                self.popup.hide();
            }, hideInMilliseconds)
        }
    }

    show() {
        this.popup.toast('show');
        return this;
    }

    hide() {
        this.popup.toast('hide');
        return this;
    }

    destroy() {
        this.popup.remove();
    }
}

class StatusPopupMessage extends PopupMessage {
    _buttonElement = null;
    _buttonCaptionElement = null;
    
    get container() {
        if (this._container == null) {
            this._container = $('#InfoToastContainer');
        }
        return this._container;
    }
    get buttonCaptionElement() {
        if (this._buttonCaptionElement == null)
            this._buttonCaptionElement = $(`#${this._buttonElement.attr("id")}_caption`);
        return this._buttonCaptionElement;
    }
    get popup() {
        let self = this;
        if (self._popup == null) {
            self._popup = $('<div>', {
                role: 'alert',
                'aria-live': 'assertive',
                'aria-atomic': 'true',
                class: 'toast text-black mb-2 shadow-sm fourover-qaal-popup',
                style: 'background-color: #FFFFF1',
                'data-bs-autohide': self.isAutohide
            });
        }
        return this._popup;
    }

    constructor(buttonElement) {
        let hostName = buttonElement.attr("host");
        let captionElement = $(`#${buttonElement.attr("id")}_caption`);
        let popup = $(`.fourover-qaal-popup-header:contains(${hostName})`);
        let popupBody = null;
        if (popup.length > 0) {
            popupBody = popup.parent().find('.popup-body-content');
            super(hostName, '', false, null, true);
        } else {
            super(hostName, '', false);
            popupBody = this.bodyContent;
        }
        let task = new TestTask(hostName, buttonElement.text(), buttonElement.attr('testCaseId'));
        task.startTask(popupBody);
    }
}

class TestTask {
    _element = null;
    _spinnerElement = null;
    _statusSuccessElement = null;
    _caption;
    _testCaseId;

    get element() {
        if (this._element == null) {
            this._element = $('<div />', {
                style: 'padding: 0'
            });
        }
        return this._element;
    }
    get spinnerElement() {
        let self = this;
        if (self._spinnerElement == null) {
            self._spinnerElement = $('<div />', {
                'class': 'spinner-border spinner-border-sm me-2',
                'role': 'status'
            })
        }
        return self._spinnerElement;
    }
    get statusSuccessElement() {
        let self = this;
        if (self._statusSuccessElement == null) {
            self._statusSuccessElement = $('<i />', {
                'class': 'bi bi-check-square-fill me-2',
            })
        }
        return self._statusSuccessElement;
    }

    constructor(executorUrl, caption, testCaseId) {
        this._caption = caption
        this._testCaseId = testCaseId;
    }

    async startTask(parentPopupBody) {
        let self = this;
        let taskId = self.uuidv4();
        let taskCaption = `Processing <i>${self._caption}</i> test...`;
        self.element.attr('id', taskId);
        self.element.append(self.spinnerElement).append(taskCaption);
        parentPopupBody.append(self.element);
        parentPopupBody.parent('.toast-body').append(parentPopupBody);
        let resultImageUrl = await Http.post(
            qaalApp.settings.qaalApiGatewayUrl,
            JSON.stringify({
                'testCaseId': self._testCaseId
            })
        );
        let hostName = parentPopupBody.parents('.toast').find('.fourover-qaal-popup-header').text();
        let taskCaptionResult = `Done <i>${self._caption}</i> test: <a href="#" imageUrl=${resultImageUrl} onclick="qaalApp.showResult('${hostName} | ${self._caption} test result', this)">result</a>`;
        let taskElement = $(`#${taskId}`);
        taskElement.empty().append(self.statusSuccessElement).append(taskCaptionResult);
    }

    uuidv4() {
        return "10000000-1000-4000-8000-100000000000".replace(/[018]/g, c =>
            (c ^ crypto.getRandomValues(new Uint8Array(1))[0] & 15 >> c / 4).toString(16)
        );
    }
}
