import puppeteerExtra from "puppeteer-extra";
import stealthPlugin from "puppeteer-extra-plugin-stealth";
import chromium from "@sparticuz/chromium";
import {Constants} from "./constants.js";
import AWS from "aws-sdk";
const s3 = new AWS.S3();
const uuidv4 = require("uuid/v4");

export class BaseTestCaseHandler {
    url;
    browser;

    constructor(url) {
        this.url = url;
        this.execute();
    }

    async execute() {
        try {
            Constants.isDev ? await this.executeDev() : await this.executeProd();
            await this.closeBrowser();
            } catch(exception) {
                console.log(`ERROR: ${exception.message}`);
            }
    }

    async executeDev() {
        puppeteerExtra.use(stealthPlugin);
        this.browser = await puppeteerExtra.launch({
            headless: "new",
            devtools: true,
            executablePath: "C:/Program Files (x86)/Google/Chrome/Application/chrome.exe"
        })
        const page = await this.browser.newPage();
        await page.goto(this.url);
        await page.screenshot({ path: `./4over_homepage.jpg` });
    }

    async executeProd() {
        puppeteerExtra.use(stealthPlugin);
        this.browser = await puppeteerExtra.launch({
            args: chromium.args,
            defaultViewport: chromium.defaultViewport,
            executablePath: await chromium.executablePath(),
            headless: chromium.headless,
            ignoreHTTPSErrors: true
        })
        const page = await this.browser.newPage();
        await page.goto(this.url);
        let imageFile = await page.screenshot();
        
    }

    async closeBrowser() {
        const pages = await this.browser.pages();
        await Promise.all(pages.map(async (page) => page.close()));
        await this.browser.close();
    }
}