import os, sys, getopt, re
import urllib2
import xmltodict
import json
import xmldiff

def main(argv):
	result = 'PASS'
	out = ''

	helpText='python dl.py  -t <trade job number> -a <api job number> (-o <testcase-name>)\n' 
	# Getting the job number from cmd
	try:
		opts, arg=getopt.getopt(argv,"a:t:o:",['apijob=','tradejob=','testcase='])
	except getopt.GetoptError:
		print 'ERROR. Please check\n'
		print helpText
		sys.exit(2)

	for opt, arg in opts:	
		if opt in ('-a','--apijob'):
			job1 = arg
		elif opt in ('-t','--tradejob'):
			job2 = arg
		elif opt in ('-o','--testcase'):
			out = arg

	if not os.path.exists('XMLDiffOut') :
		os.makedirs('XMLDiffOut')

	if out != '':
		log = 'XMLDiffOut/' + out + '-out.txt'
		log1 = 'XMLDiffOut/' + out + '-api.xml'
		log2 = 'XMLDiffOut/' + out + '-trade.xml'
		json1 = 'XMLDiffOut/' + out + '-api.json'
		json2 = 'XMLDiffOut/' + out + '-trade.json'
	else:
		log = 'XMLDiffOut/out.txt'
		log1 = 'XMLDiffOut/apilog.xml'
		log2 = 'XMLDiffOut/tradelog.xml'
		json1 = 'XMLDiffOut/apixml.json'
		json2 = 'XMLDiffOut/tradexml.json'

	if os.path.exists(log):
		os.remove(log)

	# Getting the xml from windsurfer 
	url1 = 'http://windsurfer.4over.com/pipelineupdate?filedata=' + job1
	url2 = 'http://windsurfer.4over.com/pipelineupdate?filedata=' + job2
	response = urllib2.urlopen(url1)
	apixml = response.read()
	response = urllib2.urlopen(url2)
	tradexml = response.read()

	# Write the xml to file
	with open(log1, 'w') as f:
      		f.write(apixml)
	with open(log2, 'w') as f:
      		f.write(tradexml)

	# Convert the file to list
	axml = apixml.split('\n')
	txml = tradexml.split('\n')

	# Remove the first 5 lines from the xml files and remove the word Content
     	for i in range(0,5):
        	del axml[0]
        	del txml[0]

	axml[0]=axml[0].replace("CONTENT:","")	
	txml[0]=txml[0].replace("CONTENT:","")	

	a = -1
	b = -1

	# Finding the resource_options session from api xml and looking for the line start with *
      	for i in range(0, len(axml)):
		if re.search('\/resource_options',axml[i]):
			b = i
		elif re.search('<resource_options',axml[i]):
			a = i
		elif re.match('^\*',axml[i]):
                       c =i
                       break
	# Remove all the lines after the line start with * from api xml
       	for i in range(c, len(axml)):
                del axml[c]

	# Check if resource_options session exist. If it exist, removed it from api xml.
	if a != -1 and b != -1:
		for i in range (a, b+1):
			del axml[a]
	
	# Finding the line start with * from trade xml
	for i in range(0, len(txml)):
                if re.match('^\*',txml[i]):
                       c =i
                       break
	# Remove all the lines after the line start with * 
       	for i in range(c, len(txml)):
                del txml[c]
	
	# Convert the list back to string
	apixml = "\n".join(axml[0:])
	tradexml = "\n".join(txml[0:])

	# Convert the xml string to dict
	axml = xmltodict.parse(apixml)
	txml = xmltodict.parse(tradexml)

	# Write the json format dict to file for debug reason
        with open(json1, 'w') as f:
	        f.write(json.dumps(axml,indent=4))
        with open(json2, 'w') as f:
	        f.write(json.dumps(txml,indent=4))

	# Send it to xmldiff.py to check the difference
	xmldiff.checkResponse(actual=axml, expected=txml, result=result, log=log)
	
	print log


if __name__ == "__main__":
   main(sys.argv[1:])
