import os
import sys
import getopt
import json
import pymongo
import datetime
from pymongo import MongoClient
from bson import json_util     

db = 'admin'
user = 'api'
pwd = 'api'

#host = 'dbp-001.la3.4over.com:27017'
#host = 'mongodb-las-01.4over.com:27017'
#host = 'mongodb-las-01.4over.com:27017, mongodb-las-02.4over.com:27017, mongodb-las-03.4over.com:27017'
database = db

def main(argv):
    order =''
    out = ''
    env = 'prod'
    host = 'mongodb-las-06.4over.com:27017'
    helpText='python run-Mongo.py  -o <order> (-f output_file) (-e environment)\n'
    try :
         opts, arg=getopt.getopt(argv,"hfe:o:",['order=','outfile='])
    # Print error if invalid arguments exists. It will print the help text and exit the program.
    except getopt.GetoptError:
        print(helpText)
        sys.exit(2)

# Getting the argument and setting up the variable.
    for opt, arg in opts:
        # Display help
        if opt=='-h':
            print(helpText)
            sys.exit(2)
        elif opt in ('-o','--order'):
            order=arg
        elif opt in ('-f','--outfile'):
            out=arg
        elif opt == '-e':
            env=arg

    if  order== '':
        print(helpText)
        sys.exit(2)
    if env == 'sandbox':
        host = 'mongodb-dev-02-lax.4over.com:27017'
        #print(env,host)
        #sys.exit(1)
        # Check if the output filename specific. If not, use default - result.log
    folder = 'Payload_out/'

    # If the folder doesn't exist, it will create the output folder.
    if not os.path.exists(folder) :
        os.makedirs(folder)

    if out != '':
        logf = folder + out
    else:
        logf = folder + order +'.json'

    # Connect to database
    try :
        #print 'reached mongo client'
        #client = MongoClient('mongodb://api:api@dbp-000.la3.4over.com/')
        MC = 'mongodb://'+user+':'+pwd+'@'+host+'/'
        #MC = 'mongodb://' + host
        client = MongoClient(MC)
        #client = MongoClient(MC,username='api',password='api')
        db = client.db
        req = db.Request
    except:
        print('Error during connect database.\n')
        res = None
        sys.exit(2)
    try:
        #print order
        #print req.find_one()a
            #res =  req.find_one({"created_at": {'$regex' : '/2020-09-20/'}})

        res = req.find_one({"response.job_ids.0.internal_id" : order})
            #print 'line after response'
        if res == None :
            res = req.find_one({"response.job_ids.0" : order})

        if res == None :
            k = 'response.job_ids.' + order
            res = req.find_one({k : {"$exists" : True}})

        if res == None :
            k ='response.0.job_ids.' + order
            res = db.Request.find_one({k : {"$exists" : True}})

        if res == None :
            k = "response.job_ids." + order + ".status"
            res = db.Request.find_one({"$or":[{k:"200"},{k:"400"},{k:"409"},{k:"500"}]})

    #print res
    except Exception as inst:
        print('database its using:' + database)
        print(MC)
        print(type(inst))
        print(inst.args)
        print(inst)
        print('Exception happen during fetching the payload')
        sys.exit(2)
    client.close()
    #sys.exit()
    if res != None:
        #print(res)
        #sys.exit()
        with open(logf, 'w') as f:
                #f.write(json.dumps(res, indent=4))
            f.write(json_util.dumps(res))
        print(logf)
    #print 'Please go to <a href='{logf}'> to check the output</a>.\n'.format(logf=logf)
    #print json.dumps(res, indent=4)

    else :
        print('Sorry! Unable to get the file from MongoDB. Please manually check it.\n')


if __name__ == "__main__":
   main(sys.argv[1:])
