import sys

# The keys will skip from compare
alwaysSkipTheseKeys = ('@id','timestamp','@group','@id_foreign','@version','@id_order','@id_site','source','@id_job','@id_address','email','company','firstname','lastname','phone','addr1','addr2',\
			'city','state','zip','country','@id_product_job_pricing','@mailbox_date','@drop_date')

def checkResponse(actual, expected, result, log):
	r = 0

	p = '[orders][order][job]'
	path = '[orders][order]'
	key = 'job'
	try :
		recursiveFunction(actual['orders']['order']['job'], expected['orders']['order']['job'], p, key, path, result, log)
	except:
		if p is not None:
			with open(log, 'a') as f:
                       		f.write('Exception happened. Please check it manually.\n')
			# print 'Exception happened. Please check it manually.\n'
	return result

def checklen(actual, expected):
	if len(expected) > len(actual):
		return 1
	elif len(actual) > len (expected):
		return 2
	return 0


def recursiveFunction(actual, expected, p, key, path, result, log):
	# Check if expected is dict? If so, will go through the dict key one by one
	if isinstance(expected, dict):
		# Check to see if len of actual and expected are the same
		r = checklen(actual, expected)

		# If actual had more keys than expected, set the value to actual. otherwise, set the value to expected
		if r == 2 :
			value = actual
		else:
			value = expected 

		# set the path to p
		path = '{p}'.format(p=p)

		for key in value.iterkeys():
			# Set the p
			p = '{path}[{key}]'.format(path=path, key=key)
					
			if key not in alwaysSkipTheseKeys:
				if r == 2:
					# Check to see which key is only exist in actual but not in expected.
					if key not in expected:
						result = 'FAIL'
						with open(log, 'a') as f:
                                			f.write('ERROR : API file had more keys than Trade File at {p} with key [{key}]\n'.format(p=path, key=key))
						# print 'ERROR : API file had more keys than Trade File at {p} with key [{key}]'.format(p=path, key=key)
					# Special handling if the key is equal to discounts as the display in Trade is list but in api just a value
					elif key == 'discounts':
						with open(log, 'a') as f:
							f.write('NOTE : KEY AS DISCOUNTS WHERE PATH AS {p}\n'.format(p=path))
							f.write('API is "{ak}"\n'.format(ak=actual[key]))
							f.write('Trade is "{ek}"\n'.format(ek=expected[key]))
						# print 'NOTE : KEY AS DISCOUNTS WHERE PATH AS {p}'.format(p=path)
						# print actual[key]
						# print expected[key]
					# If both exist, send it to recursiveFunction
					else :
						recursiveFunction(actual[key], expected[key], p, key, path, result, log)
				else:
					# Check to see which key is only exist in expected but not in actual.
					if key not in actual:
						result = 'FAIL'
						with open(log, 'a') as f:
                                			f.write('ERROR : Trade file had more keys than API File at {p} with key [{key}]\n'.format(p=path, key=key))
						# print 'ERROR : Trade file had more keys than API File at {p} with key [{key}]'.format(p=path, key=key)

					# If both exist, send it to recursiveFunction
					else :
						recursiveFunction(actual[key], expected[key], p, key, path, result, log)
		

	# Check if expected is list? If so, will sort the list key one by one
	elif isinstance(expected,list):
		actual.sort()
		expected.sort()
		
		# Check the size of the list
		r = checklen(actual, expected)
                if r == 1:
			## print 'expected had more keys than actual\n'
			value = len(actual)
			result = 'FAIL'
			with open(log, 'a') as f:
                       		f.write('ERROR : TRADE file had more keys than API File at {p} with key [{key}]\n'.format(p=path, key=key))
			# print 'ERROR : TRADE file had more keys than API File at {p} with key [{key}]'.format(p=path, key=key)
		elif r == 2:
			## print 'actual had more keys than expected\n'
			value = len(expected)
			result = 'FAIL'
			with open(log, 'a') as f:
                       		f.write('ERROR : API file had more keys than Trade File at {p} with key [{key}]\n'.format(p=path, key=key))
			# print 'ERROR : API file had more keys than Trade File at {p} with key [{key}]'.format(p=path, key=key)
		else :
			value = len(actual)		
	
		if p != 0:	
			path = '{p}'.format(p=p)
		for key in range(0,value):
			if p == 0:
				p='[{key}]'.format(key=key)
			else :
				p = '{path}[{key}]'.format(path=path, key=key)
			recursiveFunction(actual[key], expected[key], p, key, path, result, log)
		

	# If it is not dict and list, it will run the compare function 
	else:
		if key not in alwaysSkipTheseKeys:
			result = compare(parameter=p, actual=actual, expected=expected, result=result, log=log)
	
	return result

def compare(parameter, actual, expected, result, log):
        # Output error message if the data does not match
        if actual != expected :
                actual = str(actual)
                expected = str(expected)

		try :
                	if actual.upper() != expected.upper():
                		# print 'ERROR -{parameter}'.format(parameter=parameter)
                		# print 'ERROR : API = {actual} TRADE = {expected}\n'.format(actual=actual, expected=expected) 
                		result = 'FAIL'
				with open(log, 'a') as f:
                       			f.write('ERROR : API = {actual} TRADE = {expected} at {p}\n'.format(actual=actual, expected=expected, p=parameter)) 
		except:
                	if str(actual) != str(expected):
                		# print 'ERROR -{parameter}'.format(parameter=parameter)
                		# print 'ERROR : API = {actual} TRADE = {expected}\n'.format(actual=actual, expected=expected) 
                		result = 'FAIL'
				with open(log, 'a') as f:
                       			f.write('ERROR : API = {actual} TRADE = {expected} at {p}\n'.format(actual=actual, expected=expected, p=parameter)) 

        return result

# Most likley cause of exception is a missing or extra key in the expected file
def handleException(result, log, key, errorMessage):
        result = 'FAIL'
        # print ('ERROR: {errorMessage}').format(errorMessage=errorMessage)
	# print key
        with open(log, 'a') as f:
        	f.write("Check if around current key '{k}' is missing from actual values or extra key at actual values.\n".format(k=key))
        return result

