#!/usr/bin/env python
from selenium import webdriver
from selenium.webdriver.common.by import By
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
from selenium.webdriver.support.ui import Select
import unittest, time

'''
Luis Murillo
Last Updated: Oct 7, 2015
Python version: 2.7.8
Summary:  This script creates a Trade Business Card order using pay by check.  It adds artwork then cancels the order.
'''


class Trade_BusCard(unittest.TestCase):
    def setUp(self):
        # self.driver = webdriver.Firefox()
        self.driver = webdriver.PhantomJS()
        self.driver.implicitly_wait(30)
        self.base_url = "https://qa-trade.4over.com"

        # #Added these three lines
        # desired_cap = {'browser': 'firefox', 'browser_version': '31.0', 'os': 'Windows', 'os_version': '8.1', 'resolution': '2048x1536'}

        # #Added this line to enable the Visual Logs tab.
        # desired_cap['browserstack.debug'] = True
        # desired_cap['build'] = 'v1.0'
        # desired_cap['project'] = 'Trade'

        # #To run on BrowserStack's remote machines
        # self.driver =     webdriver.Remote(command_executor='http://dianesalter1:xXz8vB9ft7A9zjksCyBm@hub.browserstack.com:80/wd/hub', desired_capabilities=desired_cap)

        # self.driver.implicitly_wait(30)
        # self.base_url = "https://trade.4over.com/"
        # self.verificationErrors = []
        # self.accept_next_alert = True
          
    def test_trade(self):
        driver = self.driver
        driver.get(self.base_url + "")
        driver.maximize_window()
        
        driver.find_element_by_id("topLogin").clear()
        driver.find_element_by_id("topLogin").send_keys("luism@4over.com")
        
        driver.find_element_by_id("topPassword").clear()
        driver.find_element_by_id("topPassword").send_keys("production0826")
        
        WebDriverWait(self.driver, 30).until(EC.element_to_be_clickable((By.XPATH, "//*[@id='login_top']/form/div[3]/input")))   
        driver.find_element_by_xpath("//*[@id='login_top']/form/div[3]/input").click()

        # Wait for logout link to display.  This confirms user is logged in.
        WebDriverWait(self.driver, 30).until(EC.visibility_of_element_located((By.XPATH, "//*[@id='scoop']/div[4]/div[2]/a")))

        cart = driver.find_element_by_xpath("//*[@id='scoop']/div[1]/div").text
        if cart != "Cart is Empty":
            driver.find_element_by_xpath("//*[@id='scoop']/div[1]/a/img").click()
            WebDriverWait(self.driver, 30).until(EC.visibility_of_element_located((By.ID, "content")))

            # Clear cart
            driver.find_element_by_xpath("//*[@id='crazytable']/form[1]/a[2]/img").click()

            # Pop Up Window.
            WebDriverWait(self.driver, 30).until(EC.visibility_of_element_located((By.ID, "areyousure_notice")))
            driver.find_element_by_id("lb_continue").click()
            print "the cart was cleared first"

        # Click on Business cards
        driver.find_element_by_link_text("Business Cards").click()

        # Wait for the "2" X 2" BUSINESS CARDS" section to disappear.
        WebDriverWait(self.driver, 30).until(EC.invisibility_of_element_located((By.XPATH, "//*[@id='container_1']/div[1]/div[2]/div[1]")))
        
        driver.find_element_by_link_text('2" X 3.5" 14PT Business Cards UV on 4-color side(s)').click()

        # Product Builder page
        WebDriverWait(self.driver, 30).until(EC.element_to_be_clickable((By.ID, "runsize")))
        Select(driver.find_element_by_id("runsize")).select_by_visible_text("100")
        
        WebDriverWait(self.driver, 30).until(EC.element_to_be_clickable((By.ID, "color")))
        Select(driver.find_element_by_id("color")).select_by_visible_text("4:0")
        time.sleep(2)

        WebDriverWait(self.driver, 30).until(EC.element_to_be_clickable((By.ID, "tat")))
        Select(driver.find_element_by_id("tat")).select_by_visible_text("2-4 Business Days")
                
        WebDriverWait(self.driver, 30).until(EC.visibility_of_element_located((By.XPATH, "//*[@id='job_details']/table")))
        driver.find_element_by_id("job_1_job_name").send_keys("Automated Business Card Test1")
        driver.find_element_by_id("job_1_ship_type_EQ_BILL").click()

        WebDriverWait(self.driver, 30).until(EC.text_to_be_present_in_element((By.XPATH, "//*[@id='job_1_shipto_addr_display']/b"), "Job will be shipped to:"))

        driver.find_element_by_id("add_to_cart_btn").click()

        # Your Shopping Cart page
        WebDriverWait(self.driver, 30).until(EC.visibility_of_element_located((By.ID, "content")))
        self.assertEquals('2" X 3.5" 14PT Business Cards UV on 4-color side(s)', driver.find_element_by_xpath("//*[@id='crazytable']/form[1]/div[3]/table/tbody/tr[1]/td/a").text)
        self.assertEquals("$1.17", driver.find_element_by_id("total_tax").text)

        driver.find_element_by_xpath("//*[@id='cartform']/p/input[1]").click()

        # Check Payment page
        WebDriverWait(self.driver, 30).until(EC.visibility_of_element_located((By.ID, "ccpayment")))
        driver.find_element_by_xpath("//*[@id='ccpayment']/p/a/img").click()

        # Check Out Complete page
        WebDriverWait(self.driver, 30).until(EC.visibility_of_element_located((By.ID, "print_order")))
        jobid = driver.find_element_by_xpath("//*[@id='console2']/div[2]/table/tbody/tr[3]/td[2]/div/p[2]").text
        
        driver.find_element_by_xpath("//*[@id='uploadart']/a/img").click()

        # Upload Artwork page
        WebDriverWait(self.driver, 30).until(EC.visibility_of_element_located((By.ID, "artinfo")))
        driver.find_element_by_xpath("//*[@id='content']/p[2]/a").click()

        # Classic Uploader
        WebDriverWait(self.driver, 30).until(EC.visibility_of_element_located((By.ID, "uploadFile")))
        driver.find_element_by_xpath("//*[starts-with(@id,'upload_')]").send_keys("/var/application/QAAL/image/TestFile1.pdf")
        
        driver.find_element_by_id("uploadart_lofi").click()

        # Order Details page
        WebDriverWait(self.driver, 30).until(EC.visibility_of_element_located((By.ID, "cartform")))
        # Click X to cancel order
        driver.find_element_by_xpath("//*[@id='od_table']/div[2]/table/tbody/tr[3]/td[2]/p/a").click()

        # Cancellation Reason pop up window
        WebDriverWait(self.driver, 30).until(EC.visibility_of_element_located((By.ID, "lb_warning")))
        driver.find_element_by_id("cancel_reason").send_keys("testing")
        driver.find_element_by_xpath("//*[starts-with(@id,'cancel_button_')]").click()

        # Order Details page
        WebDriverWait(self.driver, 30).until(EC.visibility_of_element_located((By.ID, "ok_message")))
        self.assertEquals("Canceled (?)", driver.find_element_by_xpath("//*[@id='od_table']/div[2]/table/tbody/tr[3]/td[2]/div[1]/p[6]").text)

        # Click on Logout
        WebDriverWait(self.driver, 30).until(EC.visibility_of_element_located((By.XPATH, "//*[@id='scoop']/div[4]/div[2]/a")))
        driver.find_element_by_xpath("//*[@id='scoop']/div[4]/div[2]/a").click()
   
        print jobid
        print "Succeed"
        
    
    def tearDown(self):
        self.driver.quit()

    
if __name__ == "__main__":
    unittest.main()