#!/usr/bin/env python
from selenium import webdriver
from selenium.webdriver.common.by import By
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
from selenium.webdriver.support.ui import Select
import unittest, time

class Trade(unittest.TestCase):
    def setUp(self):

        fp = webdriver.FirefoxProfile()
        fp.add_extension(extension='/var/application/QAAL/scripts/trade/firebug/firebug-2.0.12.xpi')
        fp.add_extension(extension='/var/application/QAAL/scripts/trade/firebug/netExport-0.9b7.xpi')
        fp.add_extension(extension='/var/application/QAAL/scripts/trade/firebug/fireStarter-0.1a6.xpi')

         # Set default Firebug preferences
        fp.set_preference("extensions.firebug.currentVersion", "2.0.12") #Avoid startup screen
        fp.set_preference("extensions.firebug.allPagesActivation", "on")
        fp.set_preference("extensions.firebug.defaultPanelName", "net")
        
        # Set default Net Panel preferences
        fp.set_preference("extensions.firebug.net.enableSites", "true")
        fp.set_preference("extensions.firebug.net.defaultPersist", "true")
        
        # Set default NetExport preferences
        fp.set_preference("extensions.firebug.netexport.alwaysEnableAutoExport", "true")
        # fp.set_preference("extensions.firebug.netexport.autoExportToServer", "true")
        # fp.set_preference("extensions.firebug.netexport.beaconServerURL", "http://qaal.wqa.sbx.4over.com/scripts/trade/firebug/NetPanel_logs/")
        fp.set_preference("extensions.firebug.netexport.autoExportToFile", "true")
        fp.set_preference("extensions.firebug.netexport.defaultLogDir", "/var/application/QAAL/scripts/trade/firebug/NetPanel_logs")
        fp.set_preference("extensions.firebug.netexport.pageLoadedTimeout", 1500)
        fp.update_preferences()
        
        #Added these three lines
        # desired_cap = {'browser': 'Chrome', 'browser_version': '43.0', 'os': 'OS X', 'os_version': 'Yosemite', 'resolution': '1920x1080'}
        desired_cap = {'browser': 'Firefox', 'browser_version': '40.0', 'os': 'OS X', 'os_version': 'Yosemite', 'resolution': '1920x1080'}

        #Added this line to enable the Visual Logs tab.
        desired_cap['browserstack.debug'] = True
        desired_cap['build'] = 'v1.0'
        desired_cap['project'] = 'Trade'

        #To run on BrowserStack's remote machines
        self.driver = webdriver.Remote(command_executor='http://dianesalter1:xXz8vB9ft7A9zjksCyBm@hub.browserstack.com:80/wd/hub', desired_capabilities=desired_cap, browser_profile=fp)
        self.driver.implicitly_wait(30)
        self.base_url = "https://trade.4over.com"
        self.verificationErrors = []
        self.accept_next_alert = True
    
    def test_trade(self):
        driver = self.driver
        driver.get(self.base_url + "")
        driver.maximize_window()
        
        driver.find_element_by_id("topLogin").clear()
        driver.find_element_by_id("topLogin").send_keys("luism@4over.com")
        
        driver.find_element_by_id("topPassword").clear()
        driver.find_element_by_id("topPassword").send_keys("production0826")
        
        WebDriverWait(self.driver, 30).until(EC.element_to_be_clickable((By.XPATH, "//*[@id='login_top']/form/div[3]/input")))   
        driver.find_element_by_xpath("//*[@id='login_top']/form/div[3]/input").click()

        # Click on Business cards
        WebDriverWait(self.driver, 30).until(EC.element_to_be_clickable((By.XPATH, "//div[2]/div/div/div/div[3]/ul/li[4]/a")))   
        driver.find_element_by_link_text("Business Cards").click()
                
        # CLick on Logout
        WebDriverWait(self.driver, 30).until(EC.visibility_of_element_located((By.XPATH, "//*[@id='scoop']/div[4]/div[2]/a")))
        driver.find_element_by_xpath("//*[@id='scoop']/div[4]/div[2]/a").click()

        # time.sleep(60)

   

    def tearDown(self):
        self.driver.quit()

if __name__ == "__main__":
    unittest.main()