#!/usr/bin/env python
'''
Luis Murillo
Last Updated: December 16, 2014
Python version: 2.7.8
Summary:  This script adds 3 custom box sizes to shopping cart then deletes all items.
Steps:
    1. Login
    2. Add 4 X 6 box with default options to shopping cart.
    3. Add 3 X 27 box with DIE CUT and Glue Auto Lock Bottom options to shopping cart.
    4. Add 13 X 27 box with spot UV option to shopping cart.
    5. Delete shopping cart
    6. Logout
'''


from selenium import webdriver
from selenium.webdriver.common.by import By
from selenium.webdriver.common.keys import Keys
from selenium.webdriver.support.ui import Select
from selenium.common.exceptions import NoSuchElementException
from selenium.common.exceptions import NoAlertPresentException
import unittest, time, re

class Ultra2(unittest.TestCase):
    def setUp(self):
     #   self.driver = webdriver.Firefox()

#Added these three lines
        desired_cap = desired_cap = desired_cap = {'browser': 'Firefox', 'browser_version': '31.0', 'os': 'OS X', 'os_version': 'Mavericks', 'resolution': '1920x1080'}
                
#Added this line to enable the Visual Logs tab.
        desired_cap['browserstack.debug'] = True
        desired_cap['build'] = 'v1.0'
        desired_cap['project'] = 'Ultra'

#To run on BrowserStack's remote machines
        self.driver =     webdriver.Remote(command_executor='http://dianesalter1:xXz8vB9ft7A9zjksCyBm@hub.browserstack.com:80/wd/hub', desired_capabilities=desired_cap)


        self.driver.implicitly_wait(30)
        self.base_url = "https://4over.com/"
        self.verificationErrors = []
        self.accept_next_alert = True
    
    def test_ultra2(self):
        driver = self.driver
        driver.maximize_window()
        driver.get(self.base_url + "")
        driver.find_element_by_xpath("//input[@id='txtEmail']").clear()
        driver.find_element_by_xpath("//input[@id='txtEmail']").send_keys("luism@4over.com")
        driver.find_element_by_xpath("//input[@id='txtPassword']").clear()
        driver.find_element_by_xpath("//input[@id='txtPassword']").send_keys("production0826")
        driver.find_element_by_xpath("//input[@id='btnLogin']").click()

        driver.find_element_by_xpath("//a[contains(text(),'Custom Boxes')]").click()
      #  driver.save_screenshot('luisscreenshot.png')        
        time.sleep(5)


# 4 X 6 - Small Box price with default options starts.
        driver.find_element_by_xpath("//*[@id='short_dim']").click()
        driver.find_element_by_xpath("//*[@id='short_dim']").clear()
        driver.find_element_by_xpath("//*[@id='short_dim']").send_keys("4")
       # driver.save_screenshot('luisscreenshot.png')

        driver.find_element_by_xpath("//*[@id='long_dim']").click()
        driver.find_element_by_xpath("//*[@id='long_dim']").clear()
        driver.find_element_by_xpath("//*[@id='long_dim']").send_keys("6")
    #    driver.save_screenshot('luisscreenshot.png')

        time.sleep(1)
        driver.find_element_by_xpath("//*[@id='short_dim_finish']").click()
        driver.find_element_by_xpath("//*[@id='short_dim_finish']").clear()
        driver.find_element_by_xpath("//*[@id='short_dim_finish']").send_keys("3")
       # driver.save_screenshot('luisscreenshot.png')        

        time.sleep(1)
        driver.find_element_by_xpath("//*[@id='medium_dim_finish']").click()
        driver.find_element_by_xpath("//*[@id='medium_dim_finish']").clear()
        driver.find_element_by_xpath("//*[@id='medium_dim_finish']").send_keys("4")
       # driver.save_screenshot('luisscreenshot.png')

        time.sleep(2)
        driver.find_element_by_xpath("//*[@id='long_dim_finish']").click()
        driver.find_element_by_xpath("//*[@id='long_dim_finish']").clear()
        driver.find_element_by_xpath("//*[@id='long_dim_finish']").send_keys("5")
       # driver.save_screenshot('luisscreenshot.png')        

        time.sleep(5)
        driver.find_element_by_xpath("//div[@id='jobNameView']/div/div[2]/input").click()
        driver.find_element_by_xpath("//div[@id='jobNameView']/div/div[2]/input").clear()
        driver.find_element_by_xpath("//div[@id='jobNameView']/div/div[2]/input").send_keys("4x6CustomBox")
       # driver.save_screenshot('luisscreenshot.png')
        time.sleep(5)

        driver.find_element_by_xpath("//*[@id='btnNext']").click()
       # driver.save_screenshot('luisscreenshot.png')
        time.sleep(10)
        

        driver.find_element_by_xpath("//*[@id='fileupload']").send_keys("/var/application/QAAL/image/TestFile1.pdf")
       # driver.save_screenshot('luisscreenshot.png')
        time.sleep(10)
        
        driver.find_element_by_xpath("//div[@id='thumbnails']/figure/figcaption/div[4]/div/a/span/i").click()
       # driver.save_screenshot('luisscreenshot.png')
        
        driver.find_element_by_xpath("//a[contains(text(),'Front')]").click()
       # driver.save_screenshot('luisscreenshot.png')
        time.sleep(2)
        
        driver.find_element_by_xpath("//*[@id='btnNext']").click()
        time.sleep(10)
       # driver.save_screenshot('luisscreenshot.png')
# 4 X 6 - Small Box price ends.


# 3 X 27 - 1 Small and 1 Large Box price and DIE CUT starts.

        driver.find_element_by_xpath("//a[contains(text(),'Custom Boxes')]").click()
       # driver.save_screenshot('luisscreenshot.png')        
        time.sleep(5)

        driver.find_element_by_xpath("//*[@id='short_dim']").click()
        driver.find_element_by_xpath("//*[@id='short_dim']").clear()
        driver.find_element_by_xpath("//*[@id='short_dim']").send_keys("3")
       # driver.save_screenshot('luisscreenshot.png')

        driver.find_element_by_xpath("//*[@id='long_dim']").click()
        driver.find_element_by_xpath("//*[@id='long_dim']").clear()
        driver.find_element_by_xpath("//*[@id='long_dim']").send_keys("27")
       # driver.save_screenshot('luisscreenshot.png')

        time.sleep(1)
        driver.find_element_by_xpath("//*[@id='short_dim_finish']").click()
        driver.find_element_by_xpath("//*[@id='short_dim_finish']").clear()
        driver.find_element_by_xpath("//*[@id='short_dim_finish']").send_keys("3")
       # driver.save_screenshot('luisscreenshot.png')        

        time.sleep(1)
        driver.find_element_by_xpath("//*[@id='medium_dim_finish']").click()
        driver.find_element_by_xpath("//*[@id='medium_dim_finish']").clear()
        driver.find_element_by_xpath("//*[@id='medium_dim_finish']").send_keys("4")
       # driver.save_screenshot('luisscreenshot.png')

        time.sleep(2)
        driver.find_element_by_xpath("//*[@id='long_dim_finish']").click()
        driver.find_element_by_xpath("//*[@id='long_dim_finish']").clear()
        driver.find_element_by_xpath("//*[@id='long_dim_finish']").send_keys("5")
       # driver.save_screenshot('luisscreenshot.png')        

        Select(driver.find_element_by_xpath("//*[@id='Custom Box Die Options']")).select_by_visible_text("Yes Custom Die Cutting")
        time.sleep(3)
        Select(driver.find_element_by_xpath("//*[@id='Custom Box Glue Options']")).select_by_visible_text("Glue Auto Lock Bottom")
        time.sleep(3)
       # driver.save_screenshot('luisscreenshot.png') 


        time.sleep(5)
        driver.find_element_by_xpath("//div[@id='jobNameView']/div/div[2]/input").click()
        driver.find_element_by_xpath("//div[@id='jobNameView']/div/div[2]/input").clear()
        driver.find_element_by_xpath("//div[@id='jobNameView']/div/div[2]/input").send_keys("3x27CustomBox")
       # driver.save_screenshot('luisscreenshot.png')
        time.sleep(5)

        driver.find_element_by_xpath("//*[@id='btnNext']").click()
       # driver.save_screenshot('luisscreenshot.png')
        time.sleep(10)

        driver.find_element_by_xpath("//*[@id='fileupload']").send_keys("/var/application/QAAL/image/TestFile2Front.pdf")
       # driver.save_screenshot('luisscreenshot.png')
        time.sleep(10)
        driver.find_element_by_xpath("//*[@id='thumbnails']/figure[1]/figcaption/div[3]/div[3]/div/button[2]").click()
       # driver.save_screenshot('luisscreenshot.png')

        driver.find_element_by_xpath("//*[@id='fileupload']").send_keys("/var/application/QAAL/image/TestFile2Frontmask.pdf")
       # driver.save_screenshot('luisscreenshot.png')
        time.sleep(10)

        driver.find_element_by_xpath("//*[@id='thumbnails']/figure[2]/figcaption/div[4]/div/a").click()
       # driver.save_screenshot('luisscreenshot.png')

        driver.find_element_by_xpath("//*[@id='thumbnails']/figure[2]/figcaption/div[4]/div/ul/li[1]/a").click()
       # driver.save_screenshot('luisscreenshot.png')

        driver.find_element_by_xpath("//*[@id='thumbnails']/figure[1]/figcaption/div[4]/div/a").click()
       # driver.save_screenshot('luisscreenshot.png')
        driver.find_element_by_xpath("//*[@id='thumbnails']/figure[1]/figcaption/div[4]/div/ul/li[2]/a").click()
       # driver.save_screenshot('luisscreenshot.png')

        time.sleep(2)
        driver.find_element_by_xpath("//*[@id='btnNext']").click()
        time.sleep(10)
       # driver.save_screenshot('luisscreenshot.png')

# 3 X 27 - 1 Small and 1 Large Box price and DIE CUT ends.


# 13 X 25 - Large Box price and Spot UV starts.
        driver.find_element_by_xpath("//a[contains(text(),'Custom Boxes')]").click()
       # driver.save_screenshot('luisscreenshot.png')        
        time.sleep(5)

        driver.find_element_by_xpath("//*[@id='short_dim']").click()
        driver.find_element_by_xpath("//*[@id='short_dim']").clear()
        driver.find_element_by_xpath("//*[@id='short_dim']").send_keys("13")
       # driver.save_screenshot('luisscreenshot.png')

        driver.find_element_by_xpath("//*[@id='long_dim']").click()
        driver.find_element_by_xpath("//*[@id='long_dim']").clear()
        driver.find_element_by_xpath("//*[@id='long_dim']").send_keys("25")
       # driver.save_screenshot('luisscreenshot.png')

        time.sleep(1)
        driver.find_element_by_xpath("//*[@id='short_dim_finish']").click()
        driver.find_element_by_xpath("//*[@id='short_dim_finish']").clear()
        driver.find_element_by_xpath("//*[@id='short_dim_finish']").send_keys("3")
       # driver.save_screenshot('luisscreenshot.png')        

        time.sleep(1)
        driver.find_element_by_xpath("//*[@id='medium_dim_finish']").click()
        driver.find_element_by_xpath("//*[@id='medium_dim_finish']").clear()
        driver.find_element_by_xpath("//*[@id='medium_dim_finish']").send_keys("4")
       # driver.save_screenshot('luisscreenshot.png')

        time.sleep(2)
        driver.find_element_by_xpath("//*[@id='long_dim_finish']").click()
        driver.find_element_by_xpath("//*[@id='long_dim_finish']").clear()
        driver.find_element_by_xpath("//*[@id='long_dim_finish']").send_keys("5")
       # driver.save_screenshot('luisscreenshot.png')        

        Select(driver.find_element_by_xpath("//*[@id='Coating']")).select_by_visible_text("Spot UV, Front Only")

        time.sleep(5)
        driver.find_element_by_xpath("//div[@id='jobNameView']/div/div[2]/input").click()
        driver.find_element_by_xpath("//div[@id='jobNameView']/div/div[2]/input").clear()
        driver.find_element_by_xpath("//div[@id='jobNameView']/div/div[2]/input").send_keys("13x25CustomBox")
       # driver.save_screenshot('luisscreenshot.png')
        time.sleep(5)

        driver.find_element_by_xpath("//*[@id='btnNext']").click()
       # driver.save_screenshot('luisscreenshot.png')
        time.sleep(10)
        
 
        driver.find_element_by_xpath("//*[@id='fileupload']").send_keys("/var/application/QAAL/image/TestFile1.pdf")
       # driver.save_screenshot('luisscreenshot.png')
        time.sleep(10)
        
        driver.find_element_by_xpath("//*[@id='fileupload']").send_keys("/var/application/QAAL/image/TestFile2Frontmask.pdf")
       # driver.save_screenshot('luisscreenshot.png')
        time.sleep(10)

        driver.find_element_by_xpath("//*[@id='thumbnails']/figure[2]/figcaption/div[4]/div/a").click()
       # driver.save_screenshot('luisscreenshot.png')
        
        driver.find_element_by_xpath("//*[@id='thumbnails']/figure[2]/figcaption/div[4]/div/ul/li[1]/a").click()
       # driver.save_screenshot('luisscreenshot.png')

        driver.find_element_by_xpath("//*[@id='thumbnails']/figure[1]/figcaption/div[4]/div/a").click()
       # driver.save_screenshot('luisscreenshot.png')

        driver.find_element_by_xpath("//*[@id='thumbnails']/figure[1]/figcaption/div[4]/div/ul/li[2]/a").click()
       # driver.save_screenshot('luisscreenshot.png')

        time.sleep(2)
        driver.find_element_by_xpath("//*[@id='btnNext']").click()
        time.sleep(15)
       # driver.save_screenshot('luisscreenshot.png')
        
# 13 X 25 Large Box price and Spot UV ends.

        driver.find_element_by_xpath("//*[@id='btnDeleteCart']").click()
        time.sleep(5)
       # driver.save_screenshot('luisscreenshot.png')

        driver.find_element_by_xpath("//*[@id='logout']").click()
        time.sleep(3)
       # driver.save_screenshot('luisscreenshot.png')
        print "Succeed"

   
    def is_element_present(self, how, what):
        try: self.driver.find_element(by=how, value=what)
        except NoSuchElementException, e: return False
        return True
    
    def is_alert_present(self):
        try: self.driver.switch_to_alert()
        except NoAlertPresentException, e: return False
        return True
    
    def close_alert_and_get_its_text(self):
        try:
            alert = self.driver.switch_to_alert()
            alert_text = alert.text
            if self.accept_next_alert:
                alert.accept()
            else:
                alert.dismiss()
            return alert_text
        finally: self.accept_next_alert = True
    
    def tearDown(self):
        self.driver.quit()
        self.assertEqual([], self.verificationErrors)

if __name__ == "__main__":
    unittest.main()
